#include <stdio.h>
#include <stdlib.h>
#include <stdint.h> /* uint64_t */
#include <pthread.h>

int t; //threashold

// reference version
inline uint64_t seqfib(int n)
{
    return n < 2 ? n : seqfib(n-1) + seqfib(n-2);
}

typedef struct {
    int input;
    uint64_t output;
} thread_args;

void *thread_func(void* ptr) {
    int i = ((thread_args*)ptr)->input;
    if (i < 2)
        ((thread_args*)ptr)->output = i;
    else if (i <= t)
        ((thread_args*)ptr)->output = seqfib(i);
    else {
        thread_args args1, args2;
        pthread_t thread1, thread2;
        args1.input = i - 1;
        pthread_create(&thread1, NULL, thread_func, (void*) &args1);
        args2.input = i - 2;
        pthread_create(&thread2, NULL, thread_func, (void*) &args2);
        pthread_join(thread1, NULL);
        pthread_join(thread2, NULL);
        ((thread_args*)ptr)->output = args1.output + args2.output;
    }
    return NULL;
}

int main(int argc, char**argv) {
    pthread_t thread;
    thread_args args;
    uint64_t result;
    if (argc < 2) return 1;
    int n = atoi(argv[1]);
    t = atoi(argv[2]);
    args.input = n;
    pthread_create(&thread, NULL, thread_func, (void*) &args);
    pthread_join(thread, NULL);
    result = args.output;
    printf("Fibonacci of %d is %ld\n", n, result);
    return 0;
}
